# 第三章 开源项目发展现状

##GitHub中国项目活跃度及趋势








## 开源操作系统现状

国产开源操作系统在近年来得到飞速发展，从趋势上看，已经进入行业整体即将起飞的阶段。从传统上看，操作系统的开发属于底层基础软件，复杂性很高，开发和维护资源投入需求巨大，却很难直接转化成商业利益回报，因此一直以来大型企业对于自研操作系统的决策都是非常谨慎的，而国内专业从事操作系统开发的软件企业、操作系统厂商（OSV），却都一直处境艰难，直到今天在中国尚未出现像红帽公司（Red Hat）这样具有全球影响力的操作系统厂商，更不用说微软这样的产业巨头。近年来随着政府一系列鼓励本土操作系统发展的政策推动，国家应对信息安全威胁的需求，再加上国内市场的旺盛需求，以及国内科技实力的提升，国产操作系统的发展进入了一个迅猛发展的前夜，腾飞指日可待。

大部分的国产操作系统都是基于开源的Linux，同时也出现了像Open Harmony这样完全自主开发的操作系统。在数据中心和服务器领域，基于开源Linux操作系统进行定制化和创新是仍然是主流，但相对于早年，近年来中国操作系统行业最大的变化在于，国内系统软件社区的飞速发展和普及，社区化是相对于以前靠单个公司和组织的开发模式的显著变化，也是国内操作系统行业近年来飞速发展的引擎。国内目前有四个主流的开源操作系统社区，分别是欧拉社区（openEuler），龙蜥社区（OpenAnolis），OpenCloudOS以及OpenHarmony；目前这四个社区都已经捐赠或者正在捐赠到同一个开源基金会，开放原子基金会（OpenAtom Foundation）。

促使国内开源操作系统社区出现和迅速发展的直接因素之一，是国际开源操作系统CentOS的停止服务。CentOS是一个基于Red Hat商业版企业的开源的Linux发行版，由于与Red Hat商业版（RHEL）100%兼容，以及免费，开源的特性，长期以来国内有大量企业和用户在使用和定制基于CentOS的Linux操作系统。2020年12月，Red Hat和CentOS项目组宣布CentOS Linux项目停止维护，到2021年底CentOS8系列已经完成生命周期支持，另外CentOS7也将于2024年6月底停止支持，由此寻求CentOS的替代成为众多企业的当务之急。

龙蜥社区就是在这样的背景下应运而生，龙蜥操作系统（Anolis OS）为CentOS用户提供了平滑迁移过渡的方案，同时在此基础上，社区在操作系统的性能，安全性，云原生支持，运维等各个领域进行了自主创新。

欧拉社区是另外一个国产操作系统社区的代表，但定位略有不同，欧拉操作系统（Euler OS）并未将兼容CentOS作为主要目标，而是希望通过社区创新，打造自主的面向数字基础设施的开源操作系统，成为一个独立发展生态的社区。

OpenCloudOS则致力于打造一个完全中立、全面开放、安全稳定、高性能的操作系统及生态，在云原生、稳定性、性能、硬件支持等方面有一定的技术支撑，可以平等全面地支持所有硬件平台。

OpenHarmony是开放原子基金会旗下另外一个重要的开源操作系统社区，与其他基于Linux的操作系统不同，OpenHarmony从一开始就致力于构建一个全新，自主的系统架构和生态，目标是面向全场景、全连接、全智能时代、基于开源的方式，搭建一个智能终端设备操作系统的框架和平台，促进万物互联产业的繁荣发展；目前OpenHarmony在物联网（IoT）和嵌入式领域得到了长足发展，生态繁荣，社区参与者覆盖面很广。

在桌面操作系统领域，尽管随着时间的推移，越来越多的用户开始使用Linux桌面操作系统，但与Windows和macOS相比，Linux桌面用户的数量仍然相对较少。根据各种市场调查，全球Linux桌面市场份额大约在2％到4％之间。中国桌面Linux的市场情况与全球大体一致，同时在国产化和信创的政策推动下，国产桌面Linux操作系统在政企办公OA，金融，能源，电力等领域得到长足的发展。主要的国产桌面操作系统厂商包括统信，麒麟，红旗，中科方德，普华，中兴新支点等，同时也出现了OpenKylin这样专注于桌面操作系统的开源技术社区。

从生态上看，应用软件特别是专业应用软件的缺失，硬件（包括显卡驱动，指纹识别器和一些特殊硬件等）驱动支持不足仍然是制约国内桌面Linux操作系统普及的重要原因。

##开源与云计算的现状
云计算如今已是IT业界的主流技术，越来越多的用户选择云计算平台作为自己软件业务的基础设施，而云计算业务带来的IT产业营收比重也越发凸显。云计算的概念从上世纪八十年代发端，到真正成型落地广为人知，开源理念和开源软件在其中起到了决定性的推动作用。首先系统软件里，以Linux为代表的开源的操作系统是云计算软件技术栈里坚实的基础，还有开源的虚拟化技术对于计算资源的池化也是必不可少的一环，包括Xen，KVM，QEMU等开源项目。云计算技术需要管理的资源，除了计算资源之外，网络资源和存储资源也是缺一不可的，同样，在网络技术软件栈和存储技术软件栈里，各种逐渐成熟的开源技术和开放标准，也加速了云计算时代的到来。作为云计算产业的先锋Amazon AWS，不可否认就是架构在这一系列的开源软件之上的。在AWS稳定的技术表现和成功的商业模式的带动下，一系列开源的云计算基础架构管理软件风起云涌，而时至今日，OpenStack最终成为最为成功和唯一事实上的标准云基础设施开放平台。

同时，在过去几年里，容器化和容器资源的管理，也逐渐走向成熟，并快速被广大开发人员和厂商所采用，也标志了云（计算）原生时代的到来。在此中起关键作用的还是几个核心的开源软件项目，首先是Linux kernel里的几个核心技术带来了容器化的可能，然后Docker工具横空出世让业界快速拥抱了容器技术，容器资源从单节点走向大规模集群的过程中，Kubernetes渐渐成为了容器资源调度和编排的事实标准，可称为云原生时代的云操作系统。

存储服务支撑了应用的状态、数据的持久化，是应用得以运行的基础。云原生存储是一种用于云原生环境的存储技术，是云原生的重要组成部分，特征主要包括可用性、可扩展性、高性能、一致性以及持久性等。近年来我国出现了一批优秀成熟的开源云原生存储项目，具有代表性的有PingCap的分布式事务键值数据库TiKV，阿里巴巴的云原生镜像分发系统Dragonfly和分布式内存数据管理引擎Vineyard，以及OPPO为大规模容器平台设计的分布式文件系统CubeFS等。

###开源与云计算的趋势、挑战和机遇

2022年，随着云基础设施、网络和存储等技术发展的深入，以及以容器和微服务为代表的云原生技术兴起，云计算的发展呈现出如下的趋势，也带来了新的挑战与机遇。

**绿色云计算**

也有场合称作可持续计算（Sustainable Computing），随着云计算的普及，数据中心作为云计算的基础设施，消耗大量电力并产生大量温室气体排放，数据中心的能耗和碳排放问题日益严重，政府、企业和公众对此越来越关注。一方面能源成本上升使得运营数据中心的成本增加，为降低成本，企业开始寻求能效更高的解决方案，另一方面，各国政府对于碳排放的限制和法规，以及环保组织的倡导，促使企业采取更环保的措施。绿色云计算是指在云计算环境中采取节能、低碳、环保的方法和技术，以减少能源消耗、降低运营成本并减缓气候变化。绿色云计算的目标是在维持服务质量的同时，降低能源消耗和环境影响。

目前有多种应用于绿色云计算的技术方案，除了利用太阳能、风能、水能等可再生能源为数据中心供电，降低碳排放外，人们可以利用绿色建筑设计、合理布局、高效照明等手段，降低数据中心的能源消耗，也可以采用低功耗处理器、高效内存和绿色存储技术，减少设备的能源消耗。不论是大型数据中心（如谷歌、微软和亚马逊等云计算提供商正在利用可再生能源为其数据中心供电）还是中小型数据中心都可以利用绿色云计算技术可以帮助这些企业降低能源成本，提高设备的能效，并减少对环境的影响，而且采用绿色云计算技术可以使它们在遵守政府法规的同时，提高竞争力和市场声誉。

在软件方面，人们通过虚拟化技术对服务器进行资源整合，提高资源利用率，从而降低能耗。在容器方面，值得一提的是NRI(Node Resource Interface)技术, 它可用于控制节点资源的公共接口, 是CRI兼容的容器运行时插件扩展的通用框架。它为扩展插件提供了跟踪容器状态，并对其配置进行有限修改的基本机制。到现在为止，已经有越来越多的节点资源细粒度管理方案开始探索使用NRI实现，包括为了可持续计算而管理的资源。当NRI成为节点细粒度资源分配管理方案后，可以进一步提高资源管理方案的标准化，提高相关组件的可复用性。

在冷却技术方面，人们还可以采用高效的冷却系统和设备，如液冷、自然冷却或热管技术，降低数据中心的冷却成本，譬如2022年浪潮宣布的浪潮服务器要“All in液冷”。

最后，人们还可以采用智能能源管理系统，实时监控数据中心的能源消耗，采取节能措施以优化资源分配。许多大型数据中心都在采用绿色云计算技术，以降低能源消耗和环境影响。绿色云计算已经成为一个重要的议题，越来越多的企业、政府和组织开始关注并采取措施降低云计算对环境的影响。通过实施绿色云计算技术和策略，我们可以在享受云计算带来的便利和效率的同时，保护地球环境。

**人工智能和机器学习**
随着大数据和计算能力的发展，人工智能（AI）和机器学习（ML）技术在过去的几年里取得了显著的进展，它可以应用于如自动驾驶、金融风控、智能医疗和智能制造等各个领域。企业和研究机构对于利用人工智能和机器学习技术解决复杂问题和提高工作效率的需求日益增长。

2022年，ChatGPT的流行更是把人工智能发展推向了新高潮，ChatGPT是一款由OpenAI开发的大型自然语言处理（NLP）模型，基于GPT-4架构。它可以理解和生成自然语言文本，广泛应用于聊天机器人、自动摘要、翻译等多个领域，它深刻地影响着我们的生活、工作和学习的方方面面。

在这个爆发式增长的行业里，云计算为工智能和机器学习提供了基础算力服务，云计算提供商如谷歌、亚马逊和微软，不仅提供了一系列预构建的人工智能和机器学习服务AI-as-a-Service (AIaaS)，如语音识别、图像识别和自然语言处理等，使企业能够轻松集成和部署AI功能，而且还提供了强大的分布式计算能力，支持在多台计算机上并行执行机器学习训练任务，从而缩短训练时间。除此之外，云计算提供商还提供了基于GPU和专用AI芯片（如谷歌TPU）的计算资源，为AI提供了强大的计算能力。

**云原生技术**
在如今的云下半场中，如火如荼的云原生技术是云计算发展的主线。在CNCF基金会对云原生技术的解释中提到，云原生要用一个开源软件栈解决三个问题：一是把软件应用程序切分为多个微服务；二是把每个部分打包成容器；三是动态地编排这些容器以优化系统资源。因此，把一个单体软件应用解耦成许多微服务，并让这些微服务在各自的容器中高效协作，是云原生的重要内容和发展方向。

相对于物理机和虚拟机而言，容器是很轻量化的技术，在等量资源的基础上能创建出更多的容器实例是当下紧迫需求，容器或微服务都需要接受管理并有序接入外部环境，从而完成调度、负载均衡、分配等任务。简单且高效地管理快速增长的容器实例，是容器编排系统的主要任务，而Kubernetes就是容器编排和管理系统中的最佳选择。Kubernetes的核心是如何解决自动部署、扩展和管理容器化（Containerized）应用程序。未来，随着云原生技术的成熟和发展，企业会更多地采用云原生技术，而Kubernetes可能会继续发展，成为云原生应用部署和管理的事实标准。

**云安全**
云计算的基础是资源共享，随着越来越多的企业将其基础设施迁移到云端，云安全将成为关键领域。云提供商可能会继续加大投资以确保客户的数据安全，并采取更严格的合规和隐私政策，因此未来安全服务在云计算的发展过程中越来越重要。众所周知，数据在存储态和传输态时都已经有相应的加密机制对其进行有效保护，保障了数据的机密性和完整性，而数据在使用态时的保护正亟需新的技术填补空白。机密计算（Confidential Computing）正是基于硬件的受信任执行环境中执行计算来保护正在使用的数据，它基于建立硬件的可信执行环境（Trusted Execution Environment，TEE），如英特尔SGX和TDX，ARM TrustZone，AMD SEV/SEV-ES/SEV-SNP、RISC-V Keystone等技术，为数据在云原生环境中的安全使用提供保障。随着容器化和微服务架构的普及，确保这些技术的安全性可能会成为一个关键议题。云服务提供商和企业可能会采取更多措施来保护容器和微服务，包括运行时保护、网络隔离和加密等。目前在CNCF中就有Inclavare Containers和 Confidential Containers等开源机密计算项目，它们已经成为云安全的新趋势。

**5G与云计算融合**
5G（第五代移动通信技术）和云计算的结合为各种行业和应用带来了巨大的潜力。5G技术提供了更高的带宽、更低的延迟和更强的连接密度，这些特点使得5G与云计算的融合可以大幅提升现有应用的性能，同时创造出全新的应用场景。

譬如，边缘计算是一种将计算资源和服务部署在网络边缘（靠近数据源或用户）的技术。在某种意义上，边缘计算可以认为是云计算的扩展和延伸。边缘计算发展到今天，5G的低延迟特性使得边缘计算成为现实，可以在云计算和本地设备之间实现更高效的资源分配，但是构建分布式边缘计算基础设施工具和架构仍处于初级阶段，在边缘计算技术发展里，仍有诸多问题有待解决。国内厂商发起的KubeEdge、OpenYurt、SuperEdge等开源项目继续推进，通过边缘自治，云边流量治理，边缘设备管理等功能来实现云边协同。边缘计算可以减少数据传输延迟，提高实时性能，特别适用于自动驾驶、工业自动化、增强现实（AR）和虚拟现实（VR）等应用场景，这些边缘应用场景都是5G与云计算融合的典型案例。

再譬如，在物联网（IoT）领域，5G技术可以支持更高的连接密度，这意味着大量的物联网设备可以同时连接到网络。与云计算相结合，物联网应用可以实现更高的数据处理能力、智能分析和远程管理，这对于智能城市、智能交通和智能家居等领域具有重要意义。随着5G技术的不断发展和推广，它将与云计算形成更紧密的结合，创造出更多创新应用，为各种行业和领域带来巨大的商业价值和社会影响。可以说，5G和云计算的融合将成为推动数字化转型和智能化发展的关键力量。

##开源与人工智能

###大型自然语言处理预训练模型
近年来，随着深度学习的发展和大规模数据的积累，自然语言模型的规模和性能都有了显著的提升。2022年11月，OpenAI发布正式发布ChatGPT，仅仅2个月后，其成为迄今为止用户数最快破亿的应用，使自然语言处理（NLP）及大型自然语言模型（LLM）成为2023年最受关注的科技话题。自然语言模型的应用已进入快速发展和变革的时期，对高校学习、科研、产业应用、投融资等各社会组织活动将产生重大影响。

**中国自然语言大模型发展情况**
人工智能是国家战略的重要组成部分，是未来国际竞争的焦点和经济发展的新引擎。近年来，中国人工智能行业受到各级政府的高度重视和国家产业政策的重点支持 。为了把握新一轮科技革命和产业变革机遇，推动我国人工智能事业高质量发展，中国在“十四五”期间制定了《“十四五”智能制造发展规划》等一系列顶层设计文件，并从多个方面给予了政策扶持和资源投入。
根据《“十四五”智能制造发展规划》，中国将以数字化转型为主线，以关键核心技术突破为支撑，以场景创新为引领，以标准化建设为保障，以协同创新为动力，在2025年前实现我国智能制造水平显著提升。具体而言，在技术层面，《规划》提出加强算法创新与应用、推动算力基础设施建设、完善数据基础支撑体系等关键任务；在应用层面，《规划》提出培育一批具有全球竞争力的领军企业、打造一批示范性应用场景、构建一批开放共享平台等目标；在生态层面，《规划》提出优化政策环境、完善法律法规、加强伦理道德约束等措施。通过以上举措，《规划》旨在促进我国从传统制造大国向数字化制造强国转变，在全球产业链中占据更高端位置，在新一轮产业变革中赢得主动权。

1.政策方面：

1)加强基础研究和应用研究：《国务院办公厅关于全面加强新时代语言文字工作的意见》提出进一步推进计算机视觉、智能语音处理、生物特征识别、自然语言理解、智能决策控制以及新型人机交互等关键技术的研发和产业化，支持语言文字基础研究和应用研究，鼓励学科交叉，完善相关学科体系建设。同时，要加强语言文字数据资源的收集、整理、标注和共享，构建开放式的语言文字大数据平台，促进语言文字信息化水平的提升。建立健全自然语言处理和自然语言大模型的研发、评测、标准化、共享等体系，培育一批具有国际竞争力的核心技术和产品，提升我国在多语种文本分析、机器翻译、知识图谱、对话系统等领域的水平和影响；
2)支持产业创新和转化：《促进新一代人工智能产业发展三年行动计划（2018-2020年）》提出大力推动语言文字与人工智能、大数据、云计算等信息技术的深度融合，加强人工智能环境下自然语言处理等关键问题研究和原创技术研发，加强语言技术成果转化及推广应用，支持创业创新。同时，要加快推进自然语言处理和自然语言大模型的应用落地，打造一批具有示范效应的解决方案，促进产学研用协同创新。此外，要搭建开放包容的创新生态平台，鼓励各类主体参与自然语言处理和自然语言大模型的研究开发和商业化运营，为广大科技工作者和企业家提供政策支持和服务保障；
3)促进多领域多场景应用：以《2021年我国智能语音产业相关政策规划汇总》为例，梳理了我国部分地区出台的多项政策规划，鼓励开发自然语言处理和自然语言大模型在教育、文化、媒体、司法、医疗等行业领域的应用，提升应用场景中对于自然语言处理和生成的效率与效果，进而推动生产效率提升，并基于在具体场景中的使用，形成“使用——开发——研究”的反馈链路，加速基础研究与应用开发；通过使用自然语言大模型，可以提高各个领域和场景下的自然语言理解和生成效率和质量，实现更加便捷、准确和高效的信息交流和知识获取，并在以上领域建设国家新一代人工智能开放创新平台。

2.科研方面：
1)以鹏城实验室、智源研究院为代表的一系列科研机构的建立，进行重点攻关大规模自然语言处理领域的核心技术，逐步形成了以悟道、鹏程·盘古为代表的自然语言模型，并向产学研各界开放使用；以自由探索和目标导向相结合的体制机制，开展相关研究发表或支持发表国际AI顶会顶刊论文；与北京大学、清华大学、中国科学院等高校和科研机构建立紧密合作关系，共同培养人才和推进科技成果转化，有效促进了我国科研领域组织与人才在自然语言处理和语言模型方面不断努力和创新； 
2)国内的顶级高校，如清华大学、北京大学、复旦大学等知名高校已经成立了专门的自然语言实验室或研究组织，致力于自然语言处理和语言模型方面的研究和应用。如近期上线并开源的MOSS和ChatGLM-6B分别来自于复旦大学的邱锡鹏教授团队和清华大学孵化的智谱AI团队。高校在推动科研发展的三方面优势：一是拥有优秀的师资队伍，他们在国内外发表了大量高水平的论文，也培养了一批优秀的研究生和博士生；二是拥有强大的计算资源，他们能够利用高性能计算机和云平台进行大规模数据处理和模型训练；三是拥有广泛的合作伙伴，他们与政府、企业、社会等各界保持良好的沟通和交流，为自然语言处理技术在各个领域的落地和创新提供了支持；
3)在全球知名顶会期刊中，我国开发者体量、国内论文投递量及收录量也在逐年提高，根据斯坦福大学的AI Index统计，自2017年开始统计以来，中国AI相关的研发活力始终处于世界第二的位置；以ACL 2021为例，共有 1239 篇论文投稿来自中国大陆，其中 251 篇被接收，接收率为20.3%。

3.中文大模型案例
中国作为世界上最大的中文使用国家，也在积极探索大型语言模型的研究和应用。截至2023年，中国已经涌现出多个具有国际水平的大型中文预训练语言模型，如腾讯的混元、阿里巴巴的M6、百度的文心、鹏程·盘古、华为的盘古、智源的悟道和IDEA的封神榜等。这些模型都基于不同的架构和数据集进行了预训练，并且在不同领域展示了其强大的生成和理解能力。下面对这些模型进行简要介绍：

1)文心：文心大模型是百度为主体发布的产业级知识增强大模型，能够理解和生成自然语言，同时结合知识图谱，提升了学习效率和可解释性。文心大模型包括多个子模型，如ERNIE、PLATO、鹏城-百度·文心等，分别在语言理解、文本生成、跨模态语义理解、对话互动等领域取得多项技术突破。其中鹏城-百度·文心是全球首个知识增强千亿大模型，参数规模达到2600亿，在60多项典型任务中取得了世界领先效果，在各类AI应用场景中均具备极强的泛化能力。
2)悟道：悟道是北京智源人工智能研究院开发的一系列超大规模预训练语言模型，包括悟道1.0和悟道2.0。悟道2.0于2021年6月发布，参数量达到1.75万亿，并在世界公认的9项 Benchmark 上达到了世界第一，在多项基准测试中超越OpenAI GPT-3、DALL·E以及Google ALIGN等先进模型；除此之外，智源通过FlagAI开源平台，将悟道GLM正式开源。
3)鹏程·盘古：鹏程·盘古α大模型是鹏城实验室与华为联合研发的全球首个完全开源开放、以中文为核心的两千亿参数的预训练生成语言模型，鹏程·盘古系列大模型包括鹏程·盘古α、鹏程·盘古增强版、鹏程·盘古多语言大模型和鹏程·盘古对话生成大模型。其中鹏程·盘古增强版创新应用了多任务学习、任务统一格式、提示微调和持续学习等技术，对鹏程·盘古α基本版模型进行了能力扩展和增强。鹏程·盘古多语言大模型，首个以中文为中心的多语言&机器翻译模型，并在2022 IKCEST “一带一路”国际大数据竞赛中获得第二名。鹏程·盘古对话生成大模型是基于盘古α的开放域对话系统，可以与用户进行自然、流畅和有趣的对话。
4)华为盘古：华为盘古β大模型是循环智能与华为云联合推出千亿参数中文语言预训练模型，鹏城实验室提供算力支持。华为盘古β是2020年4月25日发布的Transformer encoder-decoder的中文理解模型，在权威的中文语言理解测评基准CLUE榜单中，总成绩及阅读理解、分类任务单项均排名第一。
5)混元：2022年底，混元1T大模型利用腾讯太极机器学习平台的高效算力和低成本网络，用千亿模型热启动的情况下，可以在256张显卡上一天内完成训练。该模型在国内最权威的自然语言理解任务榜单CLUE上取得了优异的成绩，并且已经成功应用于腾讯广告、搜索、对话等多个核心业务场景。
6)M6： M6模型是一种基于多模态（语言、图像、视频等）的人工智能预训练模型，具有10万亿级别的参数量，是中文社区最大的跨模态预训练模型。该模型通过一系列技术创新，大幅降低了训练能耗和时间，并且拥有强大的认知和创造能力。该模型在电商、制造业、文学艺术、科学研究等领域有广泛应用前景，并且已经实现了商业化落地。
7)封神榜：2021年11月，IDEA研究院正式发布了“封神榜”开源体系——一个以中文驱动的基础生态系统，其中包括了预训练大模型，特定任务的微调应用，基准和数据集等。我们的目标是构建一个全面的，标准化的，以用户为中心的生态系统。截至目前，封神榜体系中包含：二郎神、闻仲、燃灯、太乙、余元、周文王等模型。

**发展建议**

-提升算力水平
算力是支撑大规模预训练语言模型训练和部署的关键因素，需要开发和使用高效率、高性能、低成本的计算平台和硬件设备，并优化并行化和分布式计算策略。随着对模型性能要求的不断提升，对于训练模型所需的算力规模势必会不断增加，因此，集中力量建设“中国算力网”，像使用电力一样使用算力，将成为未来我国人工智能基础建设中的重要一环。
算力是支撑大规模预训练语言模型训练和部署的关键因素，需要开发和使用高效率、高性能、低成本的计算平台和硬件设备，并优化并行化和分布式计算策略。随着对模型性能要求的不断提升，对于训练模型所需的算力规模势必会不断增加，因此，集中力量建设“中国算力网”，像使用电力一样使用算力，将成为未来我国人工智能基础建设中的重要一环。通过中国算力网，实现AI算力资源的共享、调度和协同：一方面赋能用户根据需求灵活获取和使用各种类型和规模的AI算力服务，降低人工智能应用开发和部署的门槛和成本；另一方面也使得大规模算力跨区域协同计算成为可能，进而促进各地区、各行业、各领域之间的AI创新合作与交流，为我国人工智能产业发展提供强有力的支撑。
-加强数据资源建设
数据是训练大规模预训练语言模型不可或缺的基础，需要收集和整理高质量、高覆盖度、高多样性的数据集，对数据进行更加精细、更加高效的工程化处理，也将成为未来人工智能快速发展的重要基石；与此同时，数据安全和隐私保护的投入也将对大规模数据带来重要的支持作用。以GPT-4为例，其在数据工程化，特别是在动态数据更新、小样本数据微调、多模态数据融合等方面工作的尝试都产生了非常值得关注的效果。因此，如何建立我国的数据标准以及数据工程化实现方案对于提升我国在自然语言处理及语言大模型成果产生方面，将产生重大意义。
-探索新颖有效的模型架构
ChatGPT和GPT-4的成功证明，模型架构是决定大规模预训练语言模型性能和泛化能力的核心要素。因此，未来对于大模型的研发，也需要进行创新技术研究，考虑不同任务场景下特定领域知识和逻辑推理等因素。诸如多头注意力机制的改进、深度残差网络的优化、人类反馈强化学习（RLHF）的应用以及在多模态数据处理及应用方面的探索和尝试，均对新一代大模型的产生，提供了巨大的支持。随着数据量、计算资源、任务复杂度等因素不断增加，在保证可扩展性、可解释性、可控制性等方面也面临着新的挑战。因此，探索新颖而有效地语言模型架构不仅可以推动人工智能技术水平和应用价值的提升，也可以促进基础理论与前沿实践之间更紧密地结合。
4.增强开放协作
截至2023年3月，OpenAI仍未对GPT-3.5及GPT-4进行开源计划的发布，限制了其他研究者基于此的改进和创新，阻碍了模型的可解释性，也增加了模型被滥用和误用的风险。基于此，我国可以充分发挥制度优势，在中立机构的组织和协调下，团结各研究和开发力量，整合算力、数据资源，以开源开放方式进行大模型的研究与开发工作。通过开源协作，不仅能够提高我国在自然语言处理领域的技术水平和竞争力，也能够为全球社会贡献一种更公平、更透明、更可信赖的人工智能服务。同时，通过建立统一的标准和规范，我们也可以有效地保护用户隐私、维护网络安全、防止信息偏见和歧视等问题。


##开源区块链项目现状介绍
**一、 2022-2023 年该领域发展现状**
区块链技术是融合共识机制、密码学算法、智能合约的分布式账本技术，具备可追溯、不可篡改、公开透明等特性。区块链技术概念起源于比特币白皮书，但由于比特币系统技术栈中脚本语言的可编程性限制，早期的区块链生态局限在以比特币为代表的多个独立数字货币系统。2015年，以太坊系统引入图灵完备的通用编程语言作为合约开发语言，以太坊上快速涌现出一批数字资产驱动的金融类创新项目。区块链技术的迅猛发展得到各国政府和产学研界的广泛关注，在政策支持及市场驱动下，国内外诞生了一批拥有不同技术特点的区块链底层平台，应用场景也从金融领域拓展到各行各业。

区块链底层平台（以下简称区块链平台）是搭建区块链系统的关键基础设施，提供网络通信、分布式共识、合约执行、数据存储等基础功能，为各行业区块链应用落地提供支持。本文对比了国内区块链开源平台（见表1）与具备一定影响力的国外区块链开源平台（见表2）。由于本文重点关注我国区块链开源进展，国内区块链开源平台通过汇总行业白皮书、区块链信息服务备案文件、可信区块链测评、公开征集等多种渠道搜集得到，而国外区块链开源平台由于数量较多，仅遴选了star数在1000以上的知名区块链平台。

![表1：国内区块链开源平台基本信息](https://img-blog.csdnimg.cn/eab7fe5256b9486b9bc3657dbd2b6c5c.png#pic_center)
表1：国内区块链开源平台基本信息

![在这里插入图片描述](https://img-blog.csdnimg.cn/ac1a8d71d5c64dc893eded18a2786dbc.png#pic_center)
表2：国外知名区块链开源平台基本信息

可以看出，由于监管政策不同，国内外在区块链平台发展上具有明显差异。

-国外区块链平台发布时间较早，以公有链为主，大部分内置原生数字货币，并通过经济激励建设平台生态、完善社区治理。国内区块链平台以联盟链为主，大部分是无币区块链，侧重通过行业联盟与政府力量推动平台与社区建设。国内14个区块链开源平台中，联盟链共有10个，占比71.4%，国外具有较高影响力的14个区块链开源平台中，公有链共有10个，占比71.4%。
-在开源协议上，Apache 2.0占据国内开源平台的主流，占比达到42.9%，国外具有影响力的区块链开源平台中，GPL 3.0协议最多，其次是Apache 2.0协议。开源协议的使用与区块链平台类别有关，多数联盟链应用场景有闭源需求，因此联盟链平台普遍采用Apache 2.0协议，例如Hyperledger Fabric，而公有链平台则希望后续使用者持续开源，更多采用GPL 3.0协议。
-在开发语言上，无论国内外，Go语言市场占有率遥遥领先，达到46.4%，其次是C++，占比为17.9%。由于Go语言是以太坊和Hyperledger Fabric的主要开发语言，这一定程度上反映了这两个平台的生态影响力。

我们从影响力、star数、项目活跃度、最近维护时间、贡献者数量、主要贡献者数量等多个维度对国内外区块链开源项目进行比较（表3、表4）。

![在这里插入图片描述](https://img-blog.csdnimg.cn/b31d4b724bcb454a990b2a6291ff73d6.png#pic_center)
表3：国内区块链开源平台影响力与活跃度（RepChain由于托管在Gitee社区，影响力和活跃度缺失；WuTongChain, INT Chain由于影响力和活跃度较低，数据缺失）

![在这里插入图片描述](https://img-blog.csdnimg.cn/c9db331d6dea4aed9c97a84c10bcd36e.png#pic_center)
表4：国外知名区块链开源平台影响力与活跃度

对比可知，整体上，国内区块链开源平台影响力与国外有较大差距，在活跃度和贡献者数量上也有显著差距。

-拥有1000个star数以上的国外区块链开源平台有14个，而国内开源平台仅有4个。
-国内区块链开源平台的贡献者和核心贡献者数量比国外低一个数量级，例如，ChainSQL是项目规模最大的国内开源项目，贡献者、核心贡献者分别为137和53人，而以太坊分别是837和67人。
-少数国内外区块链开源平台已超过两年没有维护项目代码，例如CITA、BCOS、Wutongchain、EOS、sia，其中BCOS较为特殊，其开发团队后续迁移到FISCO BCOS项目。

2022年，区块链平台聚焦于性能优化，完善技术栈配套组件。公有链头部平台以太坊Layer2快速发展，rollup成为主流链下扩容解决方案，吸引了超过200个项目部署，显著降低交易成本。此外，以太坊共识机制在9月从POW转向POS一事引发关注，该方案预期将解决以太坊状态数据庞大带来的网络中心化问题，并为后续的分片扩容提供基础。在联盟链上，国内开源平台技术积累趋向成熟，强调全面的信创适配，包括支持国密、国产数据库、适配国产操作系统、国产CPU等。此外，国内开源平台根据业务场景逐渐完善跨链互操作、管理运维平台、隐私保护等配套组件。

在加密资产应用场景上，2022年加密资产市场行情整体低迷，市值缩水严重，以DeFi为代表的热门赛道锁仓量腰斩。Terra崩盘、FTX集团申请破产等事件使投资者遭受重大损失，严重打击市场信心。尽管NFT数字藏品在年初开启了市场新一轮热度，但在年中达到峰值后持续降低。相比国外，国内的数字藏品在上半年也同样火热，但由于禁止二级市场交易与价格炒作、强调收藏属性，行业逐渐回归理性。在产业应用场景上，我国在政务协同、司法存证、供应链溯源等重点领域探索出可行的区块链应用方案，并通过开展国家区块链创新应用试点工作形成可复制推广的典型案例和做法经验。

**二、 问题与挑战**

尽管我国有部分开源的区块链平台及配套组件，诞生了一批与实体行业结合的落地应用，但在开源领域还面临诸多挑战。

-区块链行业领域尚未形成开源共识，区块链平台开源比例低、总体数量少，部分机构仅开源配套组件或开发文档，针对最核心的底层平台仍选择闭源。
-区块链开源项目整体缺乏影响力，活跃度偏低，缺乏具备国际知名度的区块链行业团体与开源项目。
-区块链开源项目的生态建设机制、社区治理机制尚不明朗，大多数项目由单家机构维护管理，行业联盟分布式协作治理程度较低。
-缺乏具有认可度的开源测试框架、测试工具与测试数据集，关键性能指标可对比性不足。

**三、 前景、趋势与机遇**

-开源已成为软件发展的主流趋势，区块链作为构建分布式可信环境的关键技术，天然地在开源土壤中孕育成长。随着区块链技术的普及、软件社区对开源重视度的提升，是否开源将成为使用方选择区块链平台的重要指标。

-我国在区块链开源项目的数量和质量上均有较大的提升空间。除底层平台外，开源项目方正在逐渐开源多语言SDK、跨链、控制台、开发模板等组件，以丰富开源生态，扩大开源社区影响力。

-尽管国内外的政策环境不同，但开放是区块链的可信基础逐渐成为区块链从业者的共识。尽管目前我国应用场景以封闭的行业联盟链为主，但未来可能会诞生更多的开放联盟链、无币公链等提升开放能力。

**四、 发展建议**

-为扩大我国区块链开源社区的影响力，建议由具备一定影响力的行业协会牵头，联合开源底层平台的项目发布方、企事业单位、行业协会等，组建区块链开源联盟，设立联盟章程，通过制定区块链开源规范、举办区块链开源大会、定期发布开源发展报告等形式凝聚我国区块链开源社区力量。

-加大政策支持，考虑由政府部门、企事业单位、行业协会等共同出资，依托开源联盟设立区块链开源基金会，为高质量开源项目提供资金支持，同时通过举办开源比赛、高校宣讲等形式普及区块链开源知识，吸引更多人加入开源社区。


## 一、国内DevOps领域的发展现状

DevOps 是 Dev 和Ops 的组合词，是开发和运营维护的总称，是目前已经收到国内外公认的确保高效研发运维流程的方法。 随着技术的发展，高效敏捷安全的研发诉求使得DevOps领域持续受到国内外开发者的关注。在GitLab 发布的《2023 Global DevSecOps Report Series——What’s next in DevSecOps》（GitLab 2023 DevSecOps 报告）提到这样一些数据：调研报告采访了5010 名开发者，其中有56%  的开发者正在使用DevOps 或 DevSecOp的方法论，比2022年的47%有所增加。而相较于同样的进行敏捷开发的方法论，只有DevOps/DevSecOps 是唯一有所增长的。

![在这里插入图片描述](https://gitcode.net/Beckyame/copu/-/raw/master/image%20(1).png)

图来源：《2023 Global DevSecOps Report Series——What’s next in DevSecOps》

这也正说明了DevOps （包含DevSecOps）的受重视程度稳步上升。

另一方面，中国信通院领衔联合超50家企业，其中超五成的问卷受访企业资产规模在5千万元以上，覆盖全国32个省级行政区近90个城市，发布了《中国DevOps现状调查报告（2022）》梳理国内DevOps实践现状，洞察中国DevOps转型新趋势，助力企业DevOps落地实践，促进全行业DevOps演进与变革，也印证了国内对于DevOps行业的关注。

## 二、国内开源的DevOps 项目综述

国外的DevOps 生态工具链百家争鸣，而且功能丰富：

**一、版本控制&协作开发**
1. 版本控制系统 Git
Git是一个开源的分布式版本控制系统，用以有效、高速的处理从很小到非常大的项目版本管理。
2. 代码托管平台 GitLab
GitLab是一个利用Ruby on Rails开发的开源应用程序，实现一个自托管的Git项目仓库，可通过Web界面进行访问公开的或者私人项目。
3. 代码评审工具 Gerrit
Gerrit是一个免费、开放源代码的代码审查软件，使用网页界面。利用网页浏览器，同一个团队的软件程序员，可以相互审阅彼此修改后的程序代码，决定是否能够提交，退回或者继续修改。它使用Git作为底层版本控制系统。
4. 版本控制系统 Bazaar
Bazaar 是一个分布式的版本控制系统，它发布在 GPL 许可协议之下，并可用于 Windows、GNU/Linux、Unix 以及 Mac OS 系统。

**二、自动化构建和测试**
1. Apache Ant
Apache Ant是一个将软件编译、测试、部署等步骤联系在一起加以自动化的一个工具，大多用于Java环境中的软件开发。
2. JMeter
JMeter 是 Apache 组织的开放源代码项目，它是功能和性能测试的工具，100% 的用 java 实现。
3. Gradle
Gradle 就是可以使用 Groovy 来书写构建脚本的构建系统，支持依赖管理和多项目，类似 Maven，但比之简单轻便。

**三、持续集成&交付**
1.Jenkins
Jenkins 的前身是 Hudson，它是一个可扩展的持续集成引擎。
2. Fabric
fabric8 是开源 Java Containers(JVMs) 深度管理集成平台。有了 fabric8 可以非常方便的从 UI 和 UX 一致的中央位置进行自动操作，配置和管理。fabric8 同时提供一些非功能性需求，比如配置管理，服务发现故障转移，集中化监控，自动化等等。
3. Travis CI
Travis CI 是一个基于云的持续集成项目， 目前已经支持大部分主流语言了，比如：C，PHP，Ruby，Python，Nodejs等等。

**四、部署工具**
1. Docker
Docker 是一个开源的应用容器引擎，让开发者可以打包他们的应用以及依赖包到一个可移植的容器中，然后发布到任何流行的 Linux 机器上，也可以实现虚拟化。
2. Chef
Chef 是一个系统集成框架，为整个架构提供配置管理功能。
3. Ansible
Ansible 提供一种最简单的方式用于发布、管理和编排计算机系统的工具，你可在数分钟内搞定。Ansible 是一个模型驱动的配置管理器，支持多节点发布、远程任务执行。默认使用 SSH 进行远程连接。无需在被管理节点上安装附加软件，可使用各种编程语言进行扩展。

而在国内同样也有同样的DevOps 工具链生态：

**一、DevOps 一体化平台**
1. 极狐GitLab
极狐GitLab不是GitLab的中文版本，而是GitLab 版本基础上融合了本土功能的中国发行版，集成了代码管理、CI/CD、项目敏捷管理、安全监控、效能管理等覆盖软件研发全生命周期的 DevOps能力，公司在中国独立运营。
2. CODO
企业多混合云、自动化运维、完全开源的云管理平台

**二、CI/CD（持续交付、持续集成）**
1. JIANMU（建木）
建木自动化平台以触发器、流程编排、任务分发等功能为平台核心，可以应用在各类使用场景下，包括但不限于，CI/CD、DevOps、自动化运维、多业务系统集成等场景的自动化。
2. flow.ci 
采用三端架构，服务端、Web、 Agent，支持服务端的负载均衡以提高稳定性。所有任务运行在 Agent 上，并可以配置任务主机来自动调度 Agent 提升构建速度。

**三、项目管理**
1. 禅道
禅道是一款专业的国产开源研发项目管理软件，集产品管理、项目管理、质量管理、文档管理、组织管理和事务管理于一体，完整覆盖了研发项目管理的核心流程。

**四、测试可观测性**
1. Metersphere
一站式的开源持续测试平台，遵循 GPL v3 开源许可协议，涵盖测试跟踪、接口测试、UI 测试和性能测试等功能，全面兼容 JMeter、Selenium 等主流开源标准，有效助力开发和测试团队充分利用云弹性进行高度可扩展的自动化测试，加速高质量的软件交付。
2. Datakit
一款开源、一体式的数据采集可观测Agent

国内的DevOps项目虽然不及国外开源项目种类丰富数量众多，但数量还是在稳步上升。

## 三、发展的趋势：DevOps 向 DevSecOps 迈进

DevSecOps 是DevOps的下一个阶段，其目的就是为了把安全性注入到持续集成和持续交付 (CI/CD) 管道中,使开发团队能够以 DevOps 的速度应对当今所面临的一些非常紧迫的安全挑战。

![在这里插入图片描述](https://gitcode.net/Beckyame/copu/-/raw/master/image__2_.png)

DevSecOps帮助软件供应链更上一个台阶，帮助开发者和研发将安全方案集成到整个软件开发交付流程。

面对日益复杂的开发环境，GitLab 对DevOps行业的发展有这样的趋势预测：

**预测一：保护供应链安全将是最高优先级**

安全依旧是整个组织的责任，未来将进一步 “左移”，并从集成开发环境（IDE）扩展到生产环境。安全左移的目的是加强软件供应链安全。

同时软件供应链安全将朝着以下三个方向发展。
- 一线工程师将在日常运维中承担更多的威胁管理职责。为了完成这一工作，开发人员需要在软件开发生命周期的每个阶段，实时了解漏洞情况和修复策略，降低生产环境中发生严重事件的可能性。
- 安全和合规团队将把软件安全保障策略融入代码，避免因耗时的手动安全审查，拖累开发速度。
- 一些引人瞩目的安全事件进一步凸显了软件开发风险。组织将建立审计流程，更好地评估和报告 SDLC 风险。这就要求组织设计好如何交付工件，以证明其开发工具链各方面部署的控件具有不变性。

**预测二：安全将深入DevOps教育**

加速 DevOps 向 DevSecOps 的演进，将安全视为 DevOps 培训和教育课程的重要部分，组织提供培训。

**预测三：AI/ML 将贯穿 SDLC**

AI将成为提高生产力的关键, DevOps 团队将数字化转型和业务分析与AI相结合，才能让数字化转型真正发生。 AI/ML将进一步助力研发加速、安全修复和提高自动化测试以及可观测性。

**预测四：价值流分析将在组织中发挥更大作用**

价值流分析将拓宽过去的开发工作流程，从而更全面地了解组织向其用户（内部和外部）提供的价值。

**预测五：可观测性将左移，以实现高效的 DevSecOps**

可观测性将在 SDLC 中进一步左移，在提高 DevSecOps 工作流效率方面发挥重大作用，包括 CI/CD、基础设施成本分析和趋势预测，以实现更好的容量规划。

预估中国围绕DevOps生态的开源软件提供软件也会往预测的几个方向发展。




